<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateProductRequest;
use App\Http\Requests\Admin\StoreProductRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\ProductOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Product;
use Auth;
use Validator;
use Maatwebsite\Excel\Facades\Excel;

class ProductControllerR extends Controller
{
    use ProductOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:Product_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:Product_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:Product_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:Product_delete'  , ['only' => 'destroy']);
    }

    public function index()
    {
        $products = Product::latest();
        $search = array();
        if (Request()->has('title') && Request()->get('title') != '') {
            $title = Request()->get('title');
            $search['title'] = $title;

            $products = $products->where('title' , 'LIKE' ,'%'.$title.'%' );
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $products = $products->where('id'     ,$id);
        }
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $products = $products->where('status',$status);
        }
        if (Request()->has('type') && Request()->get('type') != '') {
            $type = Request()->get('type');
            $search['type'] = $type;
            $products = $products->where('type',$type);
        }
        $products = $products->paginate(10);

        $title = 'المعدات';
        return view('admin.products.index', compact('products', 'title', 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة طلب';
        return view('admin.products.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreProductRequest $request)
    {
        // return $request->all();
        $this->register($request);
        return redirect('/dashboard/products')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Product $product)
    {
        $title = 'عرض طلب';
        return view('admin.products.show', compact('product', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $title = 'تعديل طلب';
        $product = Product::find($id);
        return view('admin.products.edit', compact('product', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateProductRequest $request, Product $product)
    {
        // $product = Product::find($id);
        $this->UpdateRecords($product, $request);
        return redirect('/dashboard/products')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product $product)
    {
        if ($product->image) {
            @unlink(public_path('/cdn/'.$product->image));
        }
        $product->delete();
        return 'success';
    }
}
